# Linker-Tuning

This is the code for training and inference of Linker-tuning. Before running the training and inference scripts, you need to do the following things:
1. Create a new environment and install all the packages mentioned in the ```requirements.txt```. 
2. You need to download the pre-trained ESMFold model weights from https://github.com/facebookresearch/esm and put them in folder ```checkpoint/esmfold```.
3. For training, you need to compute distance maps of data and store it as a pickle file. The script is in ```utils/data_util.py```. 
4. You may also want to precompute the sequence representations from ESM2 for all the datasets.  The script is in ```extract_esm2_representation.py```. 
5. You may need to check if the data and model paths are matched as in the code.


## Training
```
CUDA_VISIBLE_DEVICES=0 python linker_tuning_with_esmfold_v1.py \
    --model_mode=train \
    --linker_len=25 \
    --inter_weight=4 \
    --num_recycles=1 \
    --residue_gap=0 \
    --crop \
    --dynamic \
    --crop_size=200 \
    --lr=5e-4 \
    --clipnorm=0.1 \
    --precompute_esm2 \
    --num_epochs=15 \
    --print_every=100 \
    --cp_every=1 \
    --patience=15 \
    --seed=7 \
    --data_dir=data/ \                    # specify your path here
    --backbone_dir=checkpoint/esmfold/ \  # specify your path here
    --pt_saving_dir=checkpoint/linker/con25_crop200/   # specify your path here
```


## Inference
```
CUDA_VISIBLE_DEVICES=0 python linker_tuning_with_esmfold_v1.py \
    --model_mode=test \
    --linker_len=25 \
    --num_recycles=3 \
    --residue_gap=0 \
    --pt_saving_dir=checkpoint/linker/  \    # specify your path here
    --cp_file=con25_crop200/checkpoint_best.pkl \
    --output_pdb \
    --test_name=test,test2,vhvl68 \
    --model_name=hete_con25_crop200  \
    --save_logits \
    --logit_path=results/disto_logits/       # specify your path here
```
